/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.formatter;

import com.aptana.editor.php.formatter.PHPFormatterVisitor;
import com.aptana.editor.php.formatter.nodes.FormatterPHPRootNode;
import com.aptana.editor.php.internal.indexer.PHPDocUtils;
import com.aptana.editor.php.internal.parser.nodes.PHPASTWrappingNode;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.AbstractFormatterNodeBuilder;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.ParseRootNode;
import java.util.List;
import org2.eclipse.php.internal.core.ast.nodes.Comment;
import org2.eclipse.php.internal.core.ast.nodes.Program;
import org2.eclipse.php.internal.core.ast.visitor.Visitor;

public class PHPFormatterNodeBuilder
extends AbstractFormatterNodeBuilder {
    private boolean hasErrors;

    public IFormatterContainerNode build(IParseNode parseResult, FormatterDocument document) {
        IParseNode child;
        FormatterPHPRootNode rootNode = new FormatterPHPRootNode((IFormatterDocument)document);
        this.start((IFormatterContainerNode)rootNode);
        ParseRootNode phpRootNode = (ParseRootNode)parseResult;
        if (phpRootNode.getChildCount() == 1 && (child = phpRootNode.getChild(0)) instanceof PHPASTWrappingNode) {
            Program ast = ((PHPASTWrappingNode)child).getAST();
            PHPFormatterVisitor visitor = new PHPFormatterVisitor(document, this, ast.comments());
            ast.accept((Visitor)visitor);
            this.setOffOnRegions(visitor.getOnOffRegions());
        }
        this.checkedPop((IFormatterContainerNode)rootNode, document.getLength());
        return rootNode;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public void setHasErrors(boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    public static int locateCharBackward(FormatterDocument document, char c, int start, List<Comment> comments) {
        int startOffset = start;
        int commentIndex = PHPDocUtils.findComment(comments, (int)startOffset);
        Object nextComment = null;
        int nextCommentIndex = -1;
        if (commentIndex >= 0) {
            Comment commentAtOffset = comments.get(commentIndex);
            startOffset = commentAtOffset.getStart() - 1;
            if (commentIndex > 0) {
                nextCommentIndex = commentIndex - 1;
                nextComment = comments.get(nextCommentIndex);
            }
        } else {
            nextCommentIndex = -commentIndex - 2;
            if (nextCommentIndex >= 0 && nextCommentIndex < comments.size()) {
                nextComment = comments.get(nextCommentIndex);
            }
        }
        int offset = startOffset;
        while (offset >= 0) {
            if (nextComment != null && offset >= nextComment.getStart() && offset < nextComment.getEnd()) {
                offset = nextComment.getStart();
                nextComment = --nextCommentIndex >= 0 ? comments.get(nextCommentIndex) : null;
            }
            if (document.charAt(offset) == c) {
                return offset;
            }
            --offset;
        }
        return start;
    }

    public static int locateCharForward(FormatterDocument document, char c, int start, List<Comment> comments) {
        int startOffset = start;
        int commentIndex = PHPDocUtils.findComment(comments, (int)startOffset);
        Object nextComment = null;
        int nextCommentIndex = -1;
        if (commentIndex >= 0) {
            Comment commentAtOffset = comments.get(commentIndex);
            startOffset = commentAtOffset.getEnd() + 1;
            nextCommentIndex = commentIndex + 1;
            if (nextCommentIndex < comments.size()) {
                nextComment = comments.get(nextCommentIndex);
            }
        } else {
            nextCommentIndex = -commentIndex;
            if (nextCommentIndex < comments.size()) {
                nextComment = comments.get(nextCommentIndex);
            }
        }
        int length = document.getLength();
        int offset = startOffset;
        while (offset < length) {
            if (nextComment != null && offset >= nextComment.getStart() && offset < nextComment.getEnd()) {
                offset = nextComment.getEnd() + 1;
                nextComment = ++nextCommentIndex < comments.size() ? comments.get(nextCommentIndex) : null;
            }
            if (offset >= length) break;
            if (document.charAt(offset) == c) {
                return offset;
            }
            ++offset;
        }
        return start;
    }
}

